<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Inherits="Voxco.Reporting.QPrintVariableSelection" Title="<%$ Resources:Resource, VoxcoReporting%>" Theme="Voxco" Codebehind="QPrintVariableSelection.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">    
    <div id="qprintVariableSelection">
    <telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
    <script type="text/javascript">
    
        function treeSelectedDropTest(source, dest, events)
        {
            if(dest.Value.substring(0, 3) == "OG:" && source.Parent != null && source.Parent.Value != dest.Value)
            {
                return true;
            }
            // allow moving all group's elements in another group
            if(source.Value.substring(0, 3) == "OG:" && dest.Value.substring(0, 3) == "OG:")
            {
                return true;
            }
            return false;
        }
        
        function ContextMenuClick(node, itemText)
        {
            if (itemText == "Disable")
            {
                node.Disable();
                return false;
            }
            if (itemText == "Enable All")
            {
                for (var i=0; i<node.TreeView.AllNodes.length; i++)
                {
                    node.TreeView.AllNodes[i].Enable();
                }
            }
            if (itemText == "Edit")
            {        
                node.StartEdit();
            }
            
            return true;
        }
        
        function OnCheckedNode(node)
        {
            $find("<%= VariablesRadAjaxPanel.ClientID %>").ajaxRequest("SetSelectedNodes");
        }
        
        function InputKeyUp(_buttonId, evt)
	    {
		    if (13 == evt.keyCode) 
		    {
			    __doPostBack(_buttonId,'')
		    }
	    }
        
    </script>
    </telerik:RadScriptBlock>
    
    <asp:ObjectDataSource ID="QuestionsDataSource" runat="server" SelectMethod="GetQPrintAvailable"
        TypeName="Voxco.Reporting.DataSource.QuestionsDS">
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="RowsDataSource" runat="server" SelectMethod="GetQPrintRows"
        TypeName="Voxco.Reporting.DataSource.QuestionsDS">
    </asp:ObjectDataSource>     
    
	<telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" Transparency="25" >
		<VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
	</telerik:RadAjaxLoadingPanel>

    <telerik:RadAjaxPanel ID="VariablesRadAjaxPanel" runat="server" EnableAJAX="true" LoadingPanelID="MainAjaxLoadingPanel" OnAjaxRequest="RadAjaxPanel_OnAjaxRequest" CssClass="mainContent">
            
        <asp:RadioButtonList ID="optQuestions" runat="server" AutoPostBack="True" RepeatDirection="Horizontal" 
                CellPadding="0" CellSpacing="10" OnSelectedIndexChanged="optQuestions_SelectedIndexChanged">
            <asp:ListItem Selected="True" Text="<%$ Resources:Resource, QuestionAll %>" Value="All"></asp:ListItem>
            <asp:ListItem Text="<%$ Resources:Resource, QuestionList %>" Value="List"></asp:ListItem>
            <asp:ListItem Value="Logical" Text="<%$ Resources:Resource, QuestionLogical %>"></asp:ListItem>
        </asp:RadioButtonList>
            
        <asp:Label ID="IncludeAllQuestionsLabel" runat="server" Visible="false" Text="<%$ Resources:Resource, AllAvailableQuestionsWillBeSelected %>"></asp:Label>

        <asp:Label ID="IncludeAllLogicalQuestionsLabel" runat="server" Visible="false" Text="<%$ Resources:Resource, AllAvailableLogicalQuestionsWillBeSelected %>"></asp:Label>

        <asp:Panel ID="RadSplitter1" Width="100%" Height="500px" runat="server">
			
			<div style="float: left; width: 45%;">            
                    
				<asp:Label ID="Panel2" runat="server" Text="<%$ Resources:Resource, AvailableQuestions%>" CssClass="title" />
                <br />
				
				<asp:TextBox ID="FindVariableTxt" runat="server"  Width="150px" ></asp:TextBox> 
                <asp:ImageButton ID="FindVariableBt" runat="server" ImageUrl="~/icons/ico16_find.gif" OnClick="FindVariable_Click" ToolTip="<%$ Resources:Resource, Find%>" />
                <asp:ImageButton ID="FindVariableClr" runat="server" ImageUrl="~/icons/cancel.gif" OnClick="ResetVariable_Click" ToolTip="<%$ Resources:Resource, Clear%>" />
           
                <telerik:RadGrid ID="grdQuestions" runat="server" AllowMultiRowSelection="True" Height="340px" AutoGenerateColumns="False" 
                DataSourceID="QuestionsDataSource" EnableViewState="true" OnDataBound="grdQuestions_DataBound"
                EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
                    <MasterTableView GroupLoadMode="Client" DataSourceID="QuestionsDataSource"  NoDetailRecordsText="" NoMasterRecordsText="" Width="100%">
                        <Columns>
                            <telerik:GridClientSelectColumn UniqueName="Selected">
                                <HeaderStyle Width="10%" HorizontalAlign="Left" />
							<ItemStyle Width="10%" HorizontalAlign="Left" />
                            </telerik:GridClientSelectColumn>
                            <telerik:GridBoundColumn DataField="Alias" HeaderText="<%$ Resources:Resource, Question%>" UniqueName="QuestionAlias">
								<HeaderStyle Width="90%" HorizontalAlign="Left" />
								<ItemStyle Width="90%" HorizontalAlign="Left" />
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="ChoiceCount" UniqueName="ChoiceCount" Visible="true" Display="false" ></telerik:GridBoundColumn>
                        </Columns>
                    </MasterTableView>
                    <ClientSettings AllowGroupExpandCollapse="True">
                        <Selecting UseClientSelectColumnOnly="True" AllowRowSelect="True" />
                        <Scrolling AllowScroll="true" UseStaticHeaders="True" />
                    </ClientSettings>                            
                </telerik:RadGrid>
            
            </div>
            
            <div style="float: left; width: 25px; height: 100%;" runat="server">
                
                <div class="arrows">
                <asp:ImageButton ID="btnAddAllOpen" runat="server" ImageUrl="~/icons/arrow_right_blue_open.png" OnClick="btnAddAllOpen_Click" ToolTip="<%$ Resources:Resource, SelectedAllOpenEnd %>" />    					
                    <asp:ImageButton ID="btnAddRows" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClick="btnAddRows_Click" />                            
                    <asp:ImageButton ID="btnRemoveRows" runat="server" ImageUrl="~/icons/arrow_left_blue.png" OnClick="btnRemoveRows_Click" />
                </div>
                
            </div>
            <div style="float: left; width: 45%;">            
               
				<asp:Label ID="Panel1" runat="server" Text="<%$ Resources:Resource, SelectedQuestions%>" CssClass="title" />
                <br />
                
                <asp:TextBox ID="FindSelectedVariableTxt" runat="server"  Width="150px" ></asp:TextBox> 
                <asp:ImageButton ID="FindSelectedVariableBt" runat="server" ImageUrl="~/icons/ico16_find.gif" OnClick="FindVariable_Click" ToolTip="<%$ Resources:Resource, Find%>" />
                <asp:ImageButton ID="FindSelectedVariableClr" runat="server" ImageUrl="~/icons/cancel.gif" OnClick="ResetVariable_Click" ToolTip="<%$ Resources:Resource, Clear%>" />
                    
                <telerik:RadGrid ID="grdRows" runat="server" AllowMultiRowSelection="True" Height="340px" AutoGenerateColumns="False" 
                DataSourceID="RowsDataSource" EnableViewState="true" OnDataBound="grdRows_DataBound"
                EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
                    <MasterTableView GroupLoadMode="Client" DataSourceID="RowsDataSource" NoDetailRecordsText="" NoMasterRecordsText="" Width="100%">
                        <Columns>
                            <telerik:GridClientSelectColumn UniqueName="Selected">
								<HeaderStyle Width="10%" HorizontalAlign="Left" />
								<ItemStyle Width="10%" HorizontalAlign="Left" />
                            </telerik:GridClientSelectColumn>
                            <telerik:GridBoundColumn DataField="Alias" HeaderText="<%$ Resources:Resource, Question%>" UniqueName="QuestionAlias">
								<HeaderStyle Width="90%" HorizontalAlign="Left" />
								<ItemStyle Width="90%" HorizontalAlign="Left" />
                            </telerik:GridBoundColumn>
                        </Columns>
                    </MasterTableView>
                    <ClientSettings AllowGroupExpandCollapse="True">
                        <Selecting AllowRowSelect="True" UseClientSelectColumnOnly="True" />
                        <Scrolling AllowScroll="true" UseStaticHeaders="True" />
                    </ClientSettings>                            
                </telerik:RadGrid>
                            
            </div>
        
        </asp:Panel>
        
    </telerik:RadAjaxPanel>
    </div>
</asp:Content>

